<?php

include('db.php');

// Get JSON data
$data = json_decode(file_get_contents('php://input'), true);

// Validate input data
if (empty($data['Products']) || !isset($data['Shipping'], $data['Roundoff'], $data['Discount_percentage'], $data['customerid'], $data['purchaseid'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid input data.'
    ]);
    exit;
}

$purchase_id = mysqli_real_escape_string($conn, $data['purchaseid']);
$customerid = mysqli_real_escape_string($conn, $data['customerid']);
$shipping = (float)$data['Shipping'];
$roundoff = (float)$data['Roundoff'];
$discount_percentage = (float)$data['Discount_percentage'];
$balance = isset($data['Balance']) ? (float)$data['Balance'] : 0;
$paymentid = isset($data['paymentid']) ? mysqli_real_escape_string($conn, $data['paymentid']) : '';
$products = $data['Products'];

$grand_total = 0;
$tax_total = 0;
$discount_total = 0;
$product_total = 0;
$total_savings = 0;
$total_discount = 0;

// Fetch customer name
$user_query = "SELECT displayname FROM customer WHERE id = '$customerid' AND delete_status = 0";
$user_result = mysqli_query($conn, $user_query);

if (!$user_result || mysqli_num_rows($user_result) == 0) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Customer not found or inactive.'
    ]);
    exit;
}

$user_data = mysqli_fetch_assoc($user_result);
$displayname = mysqli_real_escape_string($conn, $user_data['displayname']);

// Process each product
foreach ($products as $product) {
    if (!isset($product['Product_id'], $product['Selling_price'], $product['Tax_percentage'], $product['Qty'])) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Invalid product data.'
        ]);
        exit;
    }

    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];

    // Fetch product details
    $product_query = "SELECT Product_name, MRP, qty, sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result = mysqli_query($conn, $product_query);

    if (!$product_result || mysqli_num_rows($product_result) == 0) {
        echo json_encode([
            'status' => 'error',
            'message' => "Product ID $product_id not found or inactive."
        ]);
        exit;
    }

    $product_data = mysqli_fetch_assoc($product_result);
    if ($product_data['qty'] < $qty) {
        echo json_encode([
            'status' => 'error',
            'message' => "Insufficient stock for Product ID $product_id."
        ]);
        exit;
    }

    $mrp = (float)$product_data['MRP'];
    $sale_price_tax = (int)$product_data['sale_price_tax'];

    // Calculate values
    $discount = ($selling_price * $discount_percentage) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = ($sale_price_tax == 2) ? ($product_subtotal * $tax_percentage) / 100 : 0;

    $product_total += $product_subtotal;
    $tax_total += $tax;
    $discount_total += $discount * $qty;
    $total_savings += ($mrp - $selling_price) * $qty;
}

$grand_total = $product_total + $tax_total + $shipping - $roundoff;
$grand_total1 = number_format((float)$grand_total, 2, '.', '');

// Update `purchase` table
$created_date = mysqli_real_escape_string($conn, $data['invoicedate']);
$user_id = 1; // Replace with the actual user ID

$purchase_query = "
    UPDATE purchase
    SET
        vendor_id = '$customerid',
        displayname = '$displayname',
        Created_date = '$created_date',
        Balance = '$balance',
        Tax = '$tax_total',
        Discount = '$discount_total',
        Discount_percentage = '$discount_percentage',
        Shipping = '$shipping',
        Roundoff = '$roundoff',
        Total_price = '$product_total',
        Grand_total = '$grand_total1',
        No_of_items = '" . count($products) . "',
        Created_id = '$user_id',
        Editor_id = '$user_id',
        Delete_status = 0,
        Total_saving = '$total_savings',
        Total_discount = '$discount_total',
        Payment_status = " . ($balance == 0 ? 1 : ($balance < $grand_total ? 2 : 0)) . ",
        Payment_id = IF(Payment_id IS NULL OR Payment_id = '', '$paymentid', CONCAT(Payment_id, ',$paymentid'))
    WHERE purchase_id = '$purchase_id'
";

if (!mysqli_query($conn, $purchase_query)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to update purchase.',
        'error' => mysqli_error($conn)
    ]);
    exit;
}

// Soft delete old `purchase_data` records
$purchase_data_update_query = "
    UPDATE purchase_data 
    SET Delete_status = 1
    WHERE purchase_id = '$purchase_id'
";
mysqli_query($conn, $purchase_data_update_query);

// Insert new `purchase_data` records
foreach ($products as $product) {
    $product_id = mysqli_real_escape_string($conn, $product['Product_id']);
    $product_query2 = "SELECT MRP, sale_price_tax FROM product WHERE Product_id = '$product_id' AND Delete_status = 0";
    $product_result2 = mysqli_query($conn, $product_query2);

    $product_data2 = mysqli_fetch_assoc($product_result2);
    $selling_price = (float)$product['Selling_price'];
    $tax_percentage = (float)$product['Tax_percentage'];
    $qty = (int)$product['Qty'];
    $discount_percentage1 = (float)$product['discount_Percentage'];
    $discount = ($selling_price * $discount_percentage1) / 100;
    $product_subtotal = $selling_price * $qty;
    $tax = ($product_subtotal * $tax_percentage) / 100;
    $MRP = (float)$product_data2['MRP'];
    $Sale_Price_Tax = $product_data2['sale_price_tax'];

    $purchase_data_insert_query = "
        INSERT INTO purchase_data (
            purchase_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
            Tax_percentage, Tax, Product_total, Delete_status, salepricetax
        ) VALUES (
            '$purchase_id', '$product_id', '$qty', '$selling_price', '$MRP', '$discount', 
            '$discount_percentage1', '$tax_percentage', '$tax', '$product_subtotal', 0, '$Sale_Price_Tax'
        )
    ";

    if (!mysqli_query($conn, $purchase_data_insert_query)) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to insert purchase data.',
            'error' => mysqli_error($conn)
        ]);
        exit;
    }
}

// Return success message
echo json_encode([
    'status' => 'success',
    'message' => 'Purchase updated successfully.'
]);

?>